/*
    Copyright (C) 2016 University of the Basque Country, UPV/EHU.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/********************************************
 * Includes                                 *
 ********************************************/
#include <assert.h>
#include <string.h>

#include "utils/test_utils.h"
#include "utils/test_alg.h"
extern "C"
{
#include "core/test_grid.h"
}
#include "solvers/test_fft_ser.h"
#include "solvers/test_fft_utils_ser.h"
#include "solvers/test_solver_ser.h"
#include "test.h"

/********************************************
 * Main function                            *
 ********************************************/
int main( int argc, char* argv[] )
{
	assert( argc == 3 );

	if( !strcmp( argv[1], "src/utils/utils.cu" ) )
		return test_src_utils_utils( argv[2] );
#ifdef MOD_SERIAL
	if( !strcmp( argv[1], "src/solvers/fft_ser.cu" ) )
		return test_src_solvers_fft_ser( argv[2] );
	if( !strcmp( argv[1], "src/solvers/solver_ser.cu" ) )
		return test_src_solvers_solver_ser( argv[2] );
	if( !strcmp( argv[1], "src/solvers/fft_utils_ser.cu" ) )
		return test_src_solvers_fft_utils_ser( argv[2] );
#endif
	if( !strcmp( argv[1], "src/core/grid.c" ) )
		return test_src_core_grid( argv[2] );
	if( !strcmp( argv[1], "src/utils/alg.cu" ) )
		return test_src_utils_alg( argv[2] );

	TEST( 0 );
}
