/*
    Copyright (C) 2016 University of the Basque Country, UPV/EHU.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef UTILS_H_
#define UTILS_H_
/********************************************
 * Includes                                 *
 ********************************************/

/********************************************
 * Macros                                   *
 ********************************************/
#define MIN( a, b ) (a)<(b)?(a):(b)
#define MAX( a, b ) (a)>(b)?(a):(b)
#define ENCLOSE( x, a, b ) (x)<(a)?(a):((x)>(b)?(b):(x))

/********************************************
 * Data definitions                         *
 ********************************************/
 struct distribution
 {
 	int block_size,
 	    num_blocks,
 	    num_full_blocks,
 	    rest_block_size;
 };
 
/********************************************
 * Public function prototypes               *
 ********************************************/
void set_grid_dims( int n, int* num_blocks, int* block_size );
void set_grid_dims_specs_check( int* n, int* num_blocks, int* block_size );
void set_grid_dims_reduction( int n, int* num_blocks, int* block_size );
int* distribute( int n, int num_divs );
void distribute_blocks( int num_elements,
                        int num_blocks,
                        struct distribution* distribution );
void distribute_blocks_fairly( int num_elements,
                               int num_blocks,
                               struct distribution* distribution );
void distribute_blocks_padded( int num_elements,
                               int num_blocks,
                               struct distribution* distribution );
unsigned int get_block_offset( const struct distribution* distribution,
                               int                        index );
unsigned int get_block_size( const struct distribution* distribution,
                             int                        index );
int div_up( int dividend, int divisor );
long size2int( const char* str_size );
int find_first( int x, const int* vector, int length );
void dump_device_buffer( const void* data, int num_bytes, int id );

#endif /* UTILS_H_ */
