/*
    Copyright (C) 2016 University of the Basque Country, UPV/EHU.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef ALG_H_
#define ALG_H_

/********************************************
 * Public function prototypes               *
 ********************************************/
cup_error_t daddvv( const double* v1,
                    const double* v2,
                    double*       res,
                    int           n,
                    int           i_dev );
cup_error_t dsubvv( const double* v1,
                    const double* v2,
                    double*       res,
                    int           n,
                    int           i_dev );
cup_error_t dnorm2v( const double* v, double* res, int n  );
cup_error_t ddotp( const double* v1,
                   const double* v2,
                   double*       res,
                   int           n );
cup_error_t dsaddvv( double        c,
                     const double* v1,
                     const double* v2,
                     double*       res,
                     int           n,
                     int           i_dev );
cup_error_t dssubvv( double        c,
                     const double* v1,
                     const double* v2,
                     double*       res,
                     int           n,
                     int           i_dev );
cup_error_t dscalv( double        c,
                    const double* v,
                    double*       res,
                    int           n,
                    int           i_dev,
                    cudaStream_t  stream = 0 );

#endif /* ALG_H_ */
