/*
    Copyright (C) 2016 University of the Basque Country, UPV/EHU.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef SOLVER_H_
#define SOLVER_H_

/********************************************
 * Includes                                 *
 ********************************************/
#include <pthread.h>
#ifdef MOD_MPI
#include <mpi.h>
#endif

#include "cuPoisson.h"
#include "core/grid.h"
#include "solvers/fft_utils_ser.h"
#ifdef MOD_MPI
#include "solvers/fft_utils_mpi.h"
#endif

/********************************************
 * Data Definitions                         *
 ********************************************/
typedef enum {
	SOLVER_READY = 0,
	SOLVER_RUNNING
} solver_state;

union solver_data
{
	struct fft_solver_data fft;
};

struct cup_solver
{
	cup_solver_type_t   type;     // Solver type.
	double**            dev_data; // Data pointers (one per device).
	cup_grid*           grid;
	cup_bnd_type        boundary_type;
	cup_error_t         status;
	solver_state        state;
	struct thread_sync* state_sync;
	union solver_data   sd;       // Data particular to each solver.
	pthread_t*          threads;
	cudaStream_t*       streams;
};

#ifdef MOD_MPI
union mpi_solver_data
{
	struct mpi_fft_solver_data fft;
};

struct cup_mpi_solver
{
	struct cup_solver     base;
	int                   rank, // Precomputed from the comm field, for convenience.
	                      size; // Precomputed from the comm field, for convenience.
	MPI_Comm              comm;
	union mpi_solver_data sd;
};
#endif

#ifdef MOD_SERIAL
struct solver_thread_parms
{
	int           i_dev;
	const double* input;
	double*       output;
	cup_solver*   solver;
};
#endif

#ifdef MOD_MPI
struct mpi_solver_thread_parms
{
	const double*   input;
	double*         output;
	cup_mpi_solver* solver;
};
#endif

#endif /* SOLVER_H_ */
