/*
    Copyright (C) 2016 University of the Basque Country, UPV/EHU.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef FFT_UTILS_SER_H_
#define FFT_UTILS_SER_H_
/********************************************
 * Includes                                 *
 ********************************************/
#include "fft_utils.h"
#include "utils/utils.h"
#include "cuPoisson.h"

/********************************************
 * Data Definitions                         *
 ********************************************/
struct fft2d1d_parms
{
	int                  np_sym_dimension; // Number of points in the symetric dimension
	struct distribution  fft2d,            // How planes are distributed initialy.
	                     fft1d;            // How planes are distributed after the transposition.
};

struct thread_sync
{
	int             counter;
	pthread_mutex_t mutex;
	pthread_cond_t  cond;
};

struct fft_solver_data
{
#ifdef MOD_SERIAL
	cufftDoubleComplex** dev_buffer;    // Buffers for data exchange (one per device).
#endif
	struct fft2d1d_parms parms;
	cufftHandle*         plan_main_fw,  // Main plan (3D or 2D).
	           *         plan_main_inv,
	           *         plan_sec;      // Secondary plan (1D).
#ifdef MOD_SERIAL
	struct thread_sync*  sync2d,
	                  *  sync1d;
#endif
};

/********************************************
 * Public function prototypes               *
 ********************************************/
cup_error_t ser_set_fft_parms( cup_solver* solver );
cup_error_t ser_set_fft_plans( cup_solver* solver );
cup_error_t ser_send_fft_data( struct cup_solver* solver, int src_dev, int direction );
void solve_poisson_in_GPU( cup_solver* solver, int i_dev );

#endif /* FFT_UTILS_SER_H_ */
